function H = measureH  
% Measure transfer function H 

  global y
  global fs
  global nbits
  global channels
  global IDin
  global IDout
  global ns
  global ts
  global tp
  global td
  global tp1
  global tp2
  global audioInputName
  global audioOutputName  
  global npd
  global f
  global isHumSuppression
  global plf
  global sfontsize
  global isCancelMeasurement  
  global persParamsDir
  
  % caculate aux parameters
  
  tfft = ts + tp;            % FFT length in seconds  
  nfft = tfft * fs;          % FFT length in samples 
  nshift=(tfft+td)*fs;        % distance between sweeps in samples
  df= 1/ tfft;               % frequency resolution of FFT
  tt = tp1+ ns*tfft + tp2;   % total signal time
  
  % set up audio devices
  
  devinfo = audiodevinfo ();

  c=struct2cell(devinfo.input);
  c=c(1,1,:);
  selAidef=1;
  for i =1:length(c);
    isName=strcmpi(c(1,1,i),audioInputName);
    if isName
      selAidef=i;
    end
  end
  audioInputName = c{1,1,selAidef};
  
  c=struct2cell(devinfo.output);
  c=c(1,1,:);
  selAodef=1;
  for i =1:length(c);
    isName=strcmpi(c(1,1,i),audioOutputName);
    if isName
      selAodef=i;
    end
  end
  audioOutputName = c{1,1,selAodef}; 
  
  sn = strcat(persParamsDir,'audioDevice.mat');
  save('-mat',sn,'audioInputName','audioOutputName');
  
  IDin = audiodevinfo(1,audioInputName);
  IDout = audiodevinfo(0,audioOutputName);  
  recorder = audiorecorder (fs, nbits, channels, IDin);
  player = audioplayer (y, fs, nbits, IDout);
 
  % Create wait bar
   
  hwb=waitbar(0,'Measurement!','DeleteFcn',@(h,e) cancelMeasurement);              
  set(hwb,'windowstyle','modal');  
  set(hwb,'resize','off'); 
  hwba=get(hwb,'currentaxes');  
  set(hwba, 'fontsize',sfontsize); 
   
  % start playback and recording 
  
  play(player)
  record(recorder)
  
  % wait until recording is finished
  
  tx=0;
  dtx=0.2;  
  isCancelMeasurement = false;
  
  while (tx < tt) && ~isCancelMeasurement  
    
    pause(dtx);       

    nstr='Measurement!';
    if ishandle(hwb)
      waitbar(tx/tt,hwb,nstr); 
    end
    tx=tx+dtx; 
    
  end
  
  % stop audio devices  
  
  stop(recorder)
  stop(player)

  % get recording

  r = getaudiodata(recorder);

  peak=max(max(abs(r)));
  Lpk=20*log10(peak);
  if Lpk < -0.001
      nstr=['Lpk = ',num2str(Lpk,3),' dBFS'];
  else
      nstr='Overdriven!';
      isCancelMeasurement = true;     
  end
  if ishandle(hwb)
      waitbar(1,hwb,nstr);
  end

  % process recording if not canceled

  if ~isCancelMeasurement
    
    isCancelMeasurement = true;    
   
    % skip inital pause and average over ns sweeps
    
    r=r';  
    r=r(:,tp1*fs+1:end);  
    rr=zeros(2,nfft);
    for i = 0:ns-1
      rr=rr+r(:,1+i*nshift:nfft+i*nshift);  
    end
    rr= rr / ns;
    
    % Calulate spectra of channel l and 2
    
    U1=fft(rr(1,:)/nfft);
    U2=fft(rr(2,:)/nfft);  
    U1=2*U1(1:nfft/2);
    U2=2*U2(1:nfft/2);
    
    % Calulate transferfunction   
    
    H = U2./U1; 
    
    % do hum suppession if desired    
    
    nhmax=39; % highest hum harmonic to be suppressed
    nw=10;    % number of bins on each side of the harmonics to be suppressed
    if isHumSuppression
      for nh=1:nhmax
        fh=plf*nh;  
        ih=round(1+fh/df);
        i0=ih-nw;
        i1=ih+nw;
        H00=H(i0-1);
        H11=H(i1+1);
        dH=(H11-H00)/(2*nw+2);
        kw=1;
        for i=i0:i1
          H(i)=H00+kw*dH;
          kw=kw+1;
        end
      end
    end
    
    % resample H to log frequency scale 
    
    lf=length(f);
    Hr= zeros(1,lf);
    k1= 10^(-0.5 / npd);
    k2 = 10^(0.5/ npd);
    for i=1:lf
      f1 = k1 * f(i);
      f2 = k2 * f(i);
      r1 = f1 / df;
      r2 = f2 / df;
      n1 = round(r1);
      n2 = round(r2);
      d1 = r1 - n1;
      d2 = r2 - n2;
      w1 = 0.5 - d1;
      w2 = 0.5 + d2;
      aux = 0;
      for n= n1:1: n2
        if n==n1
          aux = aux + w1* H(n+1);
        elseif n==n2
          aux = aux + w2* H(n+1);
        else
          aux = aux + H(n+1);
        end      
      end    
      Hr(i)=aux/(r2-r1); 
    end 
    H=Hr;
  else
    
    H=[];
    
  end
  
  % Delete waitbar
  pause (2)
  if ishandle(hwb)
    delete(hwb)
  end
  
end
